#!/bin/bash
#PBS -l nodes=1:ppn=8
##PBS -l mem=100gb
#PBS -l walltime=10:00:00
#PBS -d ./
#PBS -j oe

start=`date +%s`

CPU=$PBS_NP
if [ ! $CPU ]; then
   CPU=2
fi

N=$PBS_ARRAYID
if [ ! $N ]; then
    N=1
fi

#----------------
ctg=`ls *_total.sort.bam | head -n $N | tail -n 1`
prefix=${ctg%_total.sort.bam}
program='/public1/home/miyj/sars/figs3/calculate+_.py'
file='/public1/home/miyj/sars/figs3/new.bed'
echo "CPU= $CPU"
echo "FILE= $ctg"
echo "FILE_PREFIX= $prefix"

#if [ ! -e ${prefix} ]; then
   echo "bowtie prepare"
   source activate
   conda deactivate   
   conda activate smallRNA
   python $program $ctg
   paste $file ${ctg}.txt>${prefix}.fenbu.txt
   rm ${ctg}.txt
   bamToFastq -i $ctg -fq ${prefix}_COVID.fq
   bioawk -c fastx '{print ">"$name; print $seq }' ${prefix}_COVID.fq >${prefix}_COVID.fa
   bioawk -c fastx 'length($seq)==22 {print ">"$name;print $seq}' ${prefix}_COVID.fa >${prefix}-22.fa
   rm ${prefix}_COVID.fa
   bowtie -f -v 1 -k 10 -S -t -p $CPU genome  ${prefix}-22.fa ${prefix}-22.sam
   samtools view -bS -F 4 ${prefix}-22.sam >${prefix}-22.bam
   samtools sort -m 500M -@ $CPU -o ${prefix}-22.sort.bam ${prefix}-22.bam
   samtools index ${prefix}-22.sort.bam
   rm ${prefix}-22.sam ${prefix}-22.bam
   #bamCoverage -b ${prefix}-22.sort.bam -o ${prefix}-22.sort.bw
   python $program ${prefix}-22.sort.bam
   paste $file ${prefix}-22.sort.bam.txt>${prefix}-22.fenbu.txt
   rm ${prefix}-22.sort.bam.txt

#fi

#----------------
end=`date +%s`
runtime=$((end-start))
h=$(($runtime/3600))
hh=$(($runtime%3600))
m=$(($hh/60))
s=$(($hh%60))

echo "Start= $start"
echo "End= $end"
echo "Run time= $h:$m:$s"
echo "Done!"

